@ECHO OFF
SETLOCAL EnableDelayedExpansion

REM -----------------------------------------------------------

REM Preset Default Values. These are Standard, Best Left As Is:
SET vert=0
SET hori=0
SET satn=1.0
SET dely=0

REM Preset Default Values. These for MP4 Only & Can be Changed:
SET Speed=slow
SET Compr=23
SET AudBR=256k

REM Preset Default Values. These for MP2 Only & Can be Changed:
REM Bitrate of 4830k gives 2 Hours on DVD. Change at your risk!
SET MpgBR=4830k

REM Preset Default Value. This Can be Changed to suit you best:
SET Option=1

REM Set the Source Drive Here:
SET idrv=C:
REM Set Source Directory Here: (NO DRIVE LETTER)
SET idir=\VidSrc
REM Set Output Directory Here:
SET odir=C:\VidOut
REM Set Curves acv File Directory Here: MUST Have Double "\\" for Loop Batch Files.
SET ldir=C:\\VidAcv

REM -----------------------------------------------------------

REM Preset All Control Variables for No Adjustments:
REM This allows Using Carriage Return Without Values

REM Don't Allow Looping:
SET Loop=N
REM Don't Allow Adjust Chroma Shift:
SET AdjChr=N
REM Don't Allow Adjust RGB "Curves":
SET AdjRGB=N
REM Don't Allow Adjust Saturation:
SET AdjSat=N
REM Don't Allow Adjust Audio Time:
SET AdjAud=N
REM Don't Allow Adjust Scan Types:
SET NewOpt=N
REM Don't Allow Adjust Codec Params:
SET Params=N

REM To Fix any Variables below just Swap their Paired SET/REMs over:

ECHO:
ECHO --- Adjust_Correct_Encode -- The Final GTH ACE ---
ECHO:
ECHO -1- Looping Option:

SET /p  Loop=Want Looping Instead of Single File? Then Enter Y:
REM Set Loop=Y (If Wanted Permanently: Remove Above Heading Lines)
IF %Loop%==y SET Loop=Y
IF %Loop%==Y (
IF NOT EXIST "%idrv%%idir%" (
    ECHO Error: Source directory not found at %idrv%%idir%
    ECHO Please create the correct Video Source directory
    PAUSE
    EXIT /B 1
)
IF NOT EXIST "%odir%" (
    ECHO Error: Output directory not found at %odir%
    ECHO Please create the correct Video Output directory
    PAUSE
    EXIT /B 1
)
IF NOT EXIST "%ldir%" (
    ECHO Error: "ACV" directory not found at %ldir%
    ECHO Please create the required "ACV" Files directory
    PAUSE
    EXIT /B 1
)
)

ECHO:
ECHO --- Adjust_Correct_Encode -- The Final GTH ACE ---
ECHO:
ECHO -2- Adjust_Correct:

SET /p  AdjChr=Is Chroma Shift Required? If it is Please Enter Y:
REM SET ADjChr=Y
IF %AdjChr%==y SET AdjChr=Y
IF %AdjChr%==Y (
SET /p  vert=How many Lines Vertically DOWN - Negative for UP?:
REM SET vert=-1
SET /p  hori=How many Pixels Horizontally - Negative for Left?:
REM SET hori=0
)

SET RGBcode1=
SET RGBcode2=
SET /p  AdjRGB=Is RGB "Curves" Required? If it is Please Enter Y:
REM SET AdjRGB=Y
IF %AdjRGB%==y SET AdjRGB=Y
IF %AdjRGB%==Y (
SET RGBcode2=-pix_fmt yuv420p
IF NOT %Loop%==Y (
IF NOT EXIST "%~n1.acv" (
    ECHO Error: Photoshop ACV File Not Found
    ECHO Please create a Photoshop ACV File
    PAUSE
    EXIT /B 1
)
)
)

SET /p  AdjSat=Is "Saturation" Required? If it is Please Enter Y:
REM SET AdjSat=Y
IF %AdjSat%==y SET AdjSat=Y
IF %AdjSat%==Y (
SET /p satn=Chroma Saturation Ratio. Available Range 0.0-3.0?:
)

SET /p  AdjAud=Is Audio Timing Required? (CAN'T IF TEST) Enter Y:
REM SET ADjAud=Y
IF %AdjAud%==y SET AdjAud=Y
IF %AdjAud%==Y (
SET /p  dely=Audio Delay SS.Milliseconds - Negative for Early?:
REM SET dely=0
)

ECHO:
ECHO -3- Encode or Test:

SET OptionCod1=
SET OptionCod2=
IF %Option%==1 SET /p NewOpt=Is 25i^>25p, or 25p^>25p, or 50p^>50p WRONG? Enter Y:
IF %Option%==2 SET /p NewOpt=Is 25i Video IN to Progressive 50p WRONG? Enter Y:
IF %Option%==3 SET /p NewOpt=Is 25i Video BFF to Interlaced 25i WRONG? Enter Y:
IF %Option%==4 SET /p NewOpt=Is 25i Video TFF to Interlaced 25i WRONG? Enter Y:
IF %Option%==5 SET /p NewOpt=Is 25i Video to MPEG2 Std for DVDs WRONG? Enter Y:
IF %Option%==6 SET /p NewOpt=Is 25i Video to MPEG2 Fox for DVDs WRONG? Enter Y:
IF %Option%==7 SET /p NewOpt=Is Testing Proposed Chroma Setting WRONG? Enter Y:
REM SET NewOpt=Y
IF %NewOpt%==y SET NewOpt=Y
IF %NewOpt%==Y (
ECHO Want 25i^>25p / 25p^>25p or 50p^>50p? Please Enter 1:
ECHO Want 25i Video to Progressive 50p? Please Enter 2:
ECHO Keep 25i Video BFF Interlaced 25i? Please Enter 3:
ECHO Keep 25i Video TFF Interlaced 25i? Please Enter 4:
ECHO Want 25i Video to MPEG2 Standard for DVD? Enter 5:
ECHO Want 25i Video to MPEG2 Fox New  for DVD? Enter 6:
ECHO TO TEST Proposed Chroma Settings - Please Enter 7:
SET /p Option=Please Enter Your Choice Here:
)
IF %Option%==1 SET OptionCod1=
IF %Option%==2 SET OptionCod1=bwdif,
IF %Option%==3 SET OptionCod2=-x264-params "bff=1" -flags +ilme+ildct
IF %Option%==4 SET OptionCod2=-x264-params "tff=1" -flags +ilme+ildct

IF %Option% LSS 5 (
SET /p  Params=Do %Speed%, CRF%compr%, %AudBR%b/s Need Change? Then Enter Y:
REM SET Params=Y
)
IF %Params%==y SET Params=Y
IF %Params%==Y (
ECHO Speeds: ultrafast, superfast, veryfast, fast, 
ECHO Speeds: medium -The Standard Ffmpeg Default-,
ECHO Speeds: slow -The Optimum-, slower, veryslow.
SET /p  Speed=Video Encoder Speed - fast is OK, slow is Optimum:
REM SET Speed=slow
SET /p  Compr=Video Encoder Ratio - 0 Loss Free, Max 51, Typ 23:
REM SET Compr=23
SET /p  AudBR=Audio Bit Rate bits/s - 128k = BBC or 256k Better:
REM SET AudBR=256k
)

SET Code1=0
SET Code2=0
SET Code3=0
IF %AdjChr%==Y SET Code1=1
IF %AdjSat%==Y SET Code2=2
IF %AdjAud%==Y SET Code3=4
SET /A "Code=%Code1%+%Code2%+%Code3%"
IF %Option%==5 SET Code=8
IF %Option%==6 SET Code=9
IF %Option%==7 SET Code=10

IF %Loop%==Y (
!idrv!
CD !idir!
FOR %%f IN (!idrv!!idir!\*.*) DO (
SET "Vinp=%%f"
IF %AdjRGB%==Y  SET RGBcode1=curves^=psfile^=\'!ldir!\/%%~nf.acv\',
IF NOT EXIST !ldir!\%%~nf.acv SET RGBcode1=
IF %Code% lss 8 SET "Vout=!odir!\%%~nf.mp4"
IF %Code% geq 8 SET "Vout=!odir!\%%~nf.mpg"
CALL :process
)
)

IF NOT %Loop%==Y (
SET "Vinp=%~1"
IF %AdjRGB%==Y  SET RGBcode1=curves^=psfile^='%~n1.acv',
IF %Code% lss 8 SET "Vout=%~dpn1.mp4"
IF %Code% geq 8 SET "Vout=%~dpn1.mpg"
CALL :process
)

CD "%~dp0"
REM CMD /k

GOTO :EOF

:process

IF %Code%==0 (
ffmpeg.exe -i "!Vinp!" -vf "%optionCod1% atadenoise, %RGBcode1% cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==1 (
ffmpeg.exe -i "!Vinp!" -vf "%optionCod1% atadenoise, %RGBcode1% chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==2 (
ffmpeg.exe -i "!Vinp!" -vf "%optionCod1% atadenoise, %RGBcode1% eq=saturation=%satn%, cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==3 (
ffmpeg.exe -i "!Vinp!" -vf "%optionCod1% atadenoise, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==4 (
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "%optionCod1% atadenoise, %RGBcode1% cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==5 (
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "%optionCod1% atadenoise, %RGBcode1% chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==6 (
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "%optionCod1% atadenoise, %RGBcode1% eq=saturation=%satn%, cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)
IF %Code%==7 (
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "%optionCod1% atadenoise, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -c:v libx264 %optionCod2% %RGBcode2% -preset %Speed% -crf %Compr% -c:a aac -b:a %AudBR% "!Vout!"
)

IF %Code%==8 (
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "hqdn3d, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -aspect 4/3 -alternate_scan 1 -dc 10 -g 15 -maxrate 8800k -q:v 2 -b_strategy 2 -brd_scale 2 -bf 2 -profile:v 4 -pass 1 -passlogfile "%~dp1ffmpeg" -an -c:v mpeg2video -pix_fmt yuv420p -bufsize 1835k -y NUL.m2v
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "hqdn3d, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -aspect 4/3 -alternate_scan 1 -dc 10 -g 15 -lmin 0.75 -mblmin 50 -qmin 1 -qmax 31 -maxrate 8800k -b:v %MpgBR% -bf 2 -pre_dia_size 5 -dia_size 5 -qcomp 0.7 -qblur 0 -sc_threshold 0 -bidir_refine 4 -profile:v 4 -mbd rd -mbcmp satd -precmp satd -cmp satd -subcmp satd -pass 2 -passlogfile "%~dp1ffmpeg" -c:v mpeg2video -pix_fmt yuv420p -bufsize 1835k -c:a mp2 -b:a 256k -mode stereo "!Vout!"
del "%~dp1ffmpeg-0.log"
)

IF %Code%==9 (
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "hqdn3d, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -aspect 4/3 -alternate_scan 1 -dc 10 -g 15 -maxrate 8800k -q:v 2 -b_strategy 2 -brd_scale 2 -bf 2 -profile:v 4 -intra_matrix "08,08,09,09,10,10,11,11,08,09,09,10,10,11,11,12,09,09,10,10,11,11,12,12,09,10,10,11,11,12,13,13,10,10,11,11,12,13,13,14,10,11,11,12,13,13,14,15,11,11,12,13,13,14,15,15,11,12,12,13,14,15,15,16" -inter_matrix "16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16" -pass 1 -passlogfile "%~dp1ffmpeg" -an -c:v mpeg2video -pix_fmt yuv420p -bufsize 1835k -y NUL.m2v
ffmpeg.exe -i "!Vinp!" -itsoffset "%dely%" -i "!Vinp!" -map 0:v -map 1:a -vf "hqdn3d, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas" -aspect 4/3 -alternate_scan 1 -dc 10 -g 15 -lmin 0.75 -mblmin 50 -qmin 1 -qmax 31 -maxrate 8800k -b:v %MpgBR% -bf 2 -pre_dia_size 5 -dia_size 5 -qcomp 0.7 -qblur 0 -sc_threshold 0 -bidir_refine 4 -profile:v 4 -intra_matrix "08,08,09,09,10,10,11,11,08,09,09,10,10,11,11,12,09,09,10,10,11,11,12,12,09,10,10,11,11,12,13,13,10,10,11,11,12,13,13,14,10,11,11,12,13,13,14,15,11,11,12,13,13,14,15,15,11,12,12,13,14,15,15,16" -inter_matrix "16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16" -mbd rd -mbcmp satd -precmp satd -cmp satd -subcmp satd -pass 2 -passlogfile "%~dp1ffmpeg" -c:v mpeg2video -pix_fmt yuv420p -bufsize 1835k -c:a mp2 -b:a 256k -mode stereo "!Vout!"
del "%~dp1ffmpeg-0.log"
)

IF %Code%==10 (
ffplay -i "!Vinp!" -vf "bwdif, atadenoise, %RGBcode1% eq=saturation=%satn%, chromashift=cbh="%hori%":cbv="%vert%":crh="%hori%":crv="%vert%", cas"
)

EXIT /B

@ECHO ON

